
core1 = readmatrix('core1 3m.txt');
core2 = readmatrix('core2 3m.txt');
core3 = readmatrix('core3 3m.txt');

% core1_2 = readmatrix('core1 50m.txt');
% core2_2 = readmatrix('core2 50m.txt');
% core3_2 = readmatrix('core3 50m.txt');

wavelength = core3(:,1);

x0=10;
y0=10;
width=1600;
height=700;


hold on
box on
plot(wavelength,core1(:,2),'LineWidth',1);
plot(wavelength,core2(:,2),'LineWidth',1);
plot(wavelength,core3(:,2),'LineWidth',1);
% plot(wavelength,core1_2(:,2),'LineWidth',1.5);
% plot(wavelength,core2_2(:,2),'LineWidth',1.5);
% plot(wavelength,core3_2(:,2),'LineWidth',1.5);
xlabel('Wavelength / nm')
ylabel('Signal / dB')
xlim([520 1250])
ylim([-90 -55])
legend('Core 1','Core 2','Core 3','47.7m Core 1','47.7m Core 2','47.7m Core 3')
% title('Transmission')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'FontSize',28)
set(gcf,'color','w')
set(gcf,'position',[x0,y0,width,height])
H=gca;
H.LineWidth=2;
hold off